//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "game.h"

const Entity globalEnemies[MAX_ENEMIES];
const Entity globalStaticEnemies[MAX_ENEMIES];
const Bullet globalEnemyBullets[MAX_BULLETS];
const Entity aHero;
const Entity aTarget;

void wait(){

	u32 c = 200;

	while(--c){
		cpct_waitVSYNC();
	}
}

void gameOverScoreBoard(){

    clearGameScreen();
    swapBuffers(g_scrbuffers);
    clearGameScreen();
    drawLives();

    updateScoreboard();

}

void gameover(){
    
	decompress((u8*)EXO_gameover, (u8*)EXOBUFFER_ADDRESS);
	decompress((u8*)EXO_font, (u8*)NUMBER_ADDRESS);

    gameOverScoreBoard();
    drawText("GAME OVER", MIN_Y + (MAX_Y - MIN_Y) / 2);
    swapBuffers(g_scrbuffers);

    cpct_akp_musicInit(G_gameover);
    
    while(!cpct_akp_songLoopTimes);
}

void initGame(Entity *hero, Entity *target, Bullet *bullet, Entity *enemy, Entity *staticEnemy, Prop *prop){
    
	u8 x;

	clearBullets(bullet);

	for(x=0;x<MAX_WINDOW_ENEMIES;x++){

		windows[x] = FALSE;
	}

    for(x=0;x<MAX_ENEMIES;x++){
        
    	enemy->state  = ENEMY_STATE_INACTIVE;
    	enemy->pstate = ENEMY_STATE_INACTIVE;
    	enemy->cycles = 0;
    	enemy->bullet = MAX_BULLETS + 1;
    	enemy->lastTile = 50;

    	enemy++;
    }

    //entity = staticEnemies;

    for(x=0;x<MAX_ENEMIES;x++){

    	staticEnemy->state = ENEMY_STATE_INACTIVE;

   		addEntity(prop->type, prop->xPos, prop->yPos, 0, staticEnemy, 100);
       	prop++;
       	staticEnemy++;
    }

    hero->state 	= HERO_STATE_ON_FLOOR;
	hero->xPos  	= MIN_X + (MAX_X - MIN_X) / 2;
	hero->yPos  	= HERO_FLOOR_Y;
	hero->pxPos  	= MIN_X + (MAX_X - MIN_X) / 2;
	hero->cycles 	= 0;


	target->state 	= HERO_STATE_ON_FLOOR;
	target->xPos  	= MIN_X + 1 + (MAX_X - MIN_X) / 2;
	target->yPos  	= HERO_FLOOR_Y - 30;
	target->pxPos  	= MIN_X + 1 +(MAX_X - MIN_X) / 2;
	target->pyPos  	= HERO_FLOOR_Y - 40;
	target->cycles 	= 0;

    //Decompress tileset
	decompress((u8*)EXO_tileset, (u8*)TILES_ADDRESS);
	drawTileBox2x4(0, 0, 20, 16, SCR_BUFF, level - 1);

	updateScoreboard();
	drawLives();

	cpct_memcpy(SCR_VMEM, SCR_BUFF, 0x4000);

}


void addEnemies(u8 alevel){

	u8 rand = cpct_rand() % (MAX_RESPAWNS + 1);

	if(rand < MAX_RESPAWNS){

		Respawn *respawn = &levelRespawns[alevel][rand];

		addEntity(respawn->type, respawn->coords.xPos, respawn->coords.yPos, respawn->direction, globalEnemies, 100);

	}

	else if(alevel % 3 == 0){

		switch (alevel) {

			case 0:

				rand = 0;
				break;

			case 3:

				rand = cpct_rand() % 2;
				break;

			case 6:

				rand = cpct_rand() % 3;
				break;

		}

		alevel = alevel / 3;

		if(!windows[rand]) addEntity(ENEMY_TYPE_WINDOW, windowRespawns[alevel][rand].coords.xPos, windowRespawns[alevel][rand].coords.yPos, 1, globalEnemies, rand);

	}
}

void playLevel(){

	Entity *hero 	= &aHero;
	Entity *target 	= &aTarget;
	u8 end = FALSE;
	u8 contador = 0;
	u8 props = level - 1;
	u8 protection;

	if(bonus){
		enemiesToKill = MAX_ENEMIES;
		if(level == 1) props = MAX_LEVELS;//9
		else props = MAX_LEVELS + 1; //10
	}


    initGame(hero, target, globalEnemyBullets, globalEnemies, globalStaticEnemies, levelProps[props]);

    while(1){

        if(!pause){

        	//Drawing
            drawEnemies(globalEnemies, TRUE, hero, globalEnemyBullets);
            drawEnemies(globalStaticEnemies, TRUE, hero, globalEnemyBullets);
            drawBullets(globalEnemyBullets, TRUE);
            drawTarget(target, TRUE);
            drawHero(hero, target, globalEnemyBullets, TRUE);

            cpct_waitVSYNC();
            swapBuffers(g_scrbuffers);

            if(gameOver == TRUE || enemiesToKill <= 0) return;

            //Delete elements

			drawBullets(globalEnemyBullets, FALSE);
			drawEnemies(globalEnemies, FALSE, hero, globalEnemyBullets);
			drawEnemies(globalStaticEnemies, FALSE, hero, globalEnemyBullets);
			drawTarget(target, FALSE);
			drawHero(hero, target, globalEnemyBullets, FALSE);

			if(!bonus && ++contador == 8){

				addEnemies(props);
				contador = 0;

			}

			//Move elements
			moveBullets(hero, globalEnemyBullets);
			protection = moveEnemies(globalStaticEnemies, target, hero, keys.fire, FALSE);
			moveEnemies(globalEnemies, target, hero, keys.fire, protection);

			checkKeyboardGame(hero, target);
			if(bonus) cpct_waitVSYNC();

        }
        else{

            checkKeyboardGame(hero, target);
        }

    }


}


void showLevelNumber(){

	u8 leveltext[8] = "LEVEL 0";
	decompress((u8*)EXO_font, (u8*)NUMBER_ADDRESS);

	gameOverScoreBoard();

	if(level == 1 && bonus) drawText("TRAIN YOUR AIM", MIN_Y + (MAX_Y - MIN_Y) / 2);
	else if(bonus) drawText("BONUS LEVEL", MIN_Y + (MAX_Y - MIN_Y) / 2);
	else{

		leveltext[6] = level + 48;
		drawText(leveltext, MIN_Y + (MAX_Y - MIN_Y) / 2);

	}


	swapBuffers(g_scrbuffers);

	wait();
}

void ending(){

	decompress((u8*)EXO_font, (u8*)NUMBER_ADDRESS);

	waitKeyUp(keys.fire);
	gameOverScoreBoard();
	drawText("A NEW PERIOD OF PEACE IS", 0);
	drawText("COMING BUT DANIEL COLT", 20);
	drawText("WILL SOON BE BACK@", 40);
	drawText("SEE YOU IN OUTLAWS 2", 90);

	swapBuffers(g_scrbuffers);
	wait4Key(keys.fire);

}

void game(){

	gameOver = FALSE;
	pause = FALSE;

	lives = MAX_LIVES;
	score = 0;
	level = 1;
	bonus = TRUE;


	loopMusic = FALSE;
	cpct_akp_musicInit(G_tururu);

	while(!gameOver && level <= MAX_LEVELS){

		if(level < 4) enemiesToKill = 40;
		else if(level < 7) enemiesToKill = 50;
		else enemiesToKill = 60;

		showLevelNumber();
		playLevel();

		if(!gameOver){

			cpct_akp_musicInit(G_tururu);

			wait();

			if(!bonus){
				level++;
				if(level == 4 || level == 7) bonus = 1;
			}
			else bonus = FALSE;

		}

	}

	if(level > MAX_LEVELS){
		score += 2500;
		updateScoreboard();
		ending();
	}

	gameover();
}

void myInterruptHandler() {

    static u8 i;

    i++;
    switch(i) {
       case 4:
          cpct_scanKeyboard_if();
          break;
       case 5:
    	  if(!loopMusic && cpct_akp_songLoopTimes) cpct_akp_musicInit(G_FX);
    	  cpct_akp_musicPlay();
    	  break;
       case 6:
          i=0;
    }
     
}

void outlaws(){

    drawMenu();

    while (1){
        
        checkKeyboardMenu();

    }
}
